//
//	Class definition for Test Dialog class
//

#ifndef THE_TIP_DIALOG_H
#define THE_TIP_DIALOG_H

#include "ldwTiledDialog.h"
#include "ldwImage.h"
#include "ldwGameWindow.h"
#include "../Utils/theStringManager.h"

class ldwButton;
class ldwTiledBackground;
class ldwImageGrid;
class theGameState;

enum ArrowDirection {eNoArrow,eUpArrow,eDownArrow,eLeftArrow,eRightArrow};

enum TipDialogResult {eTipOkClicked,eTipInterrupted};

class theTipDialog : public ldwTiledDialog
{
public:

	theTipDialog(StringId whatTip,ArrowDirection arrowDirection = eNoArrow,int x = 0, int y = 0,bool onWorld = false);
	theTipDialog(const char *tipString);

	~theTipDialog();
	
	int  GetResult();

	bool HandleMessage(int messageId,long data);
	bool HandleMouse(int messageId,ldwPoint location);

	bool IsTutorialTip() {return mTutorialTip;}

protected:

	void Init(const char *tipString,ArrowDirection arrowDirection = eNoArrow,int x = 0, int y = 0,bool onWorld = false);

	void DrawNoFadeScene();

	bool mTutorialTip;
	bool mCountingDown;

	ldwUINT32 mEndTime;

	StringId whatTip;

	const char *mTipString;

	int textWidth;
	int textOffsetY;

	const int cChoiceAButtonID;

	theGameState     *gs;
	ldwGameWindow    *gameWindow;
	theStringManager *strMgr;

	ldwButton  *choiceAButton;

	ArrowDirection     mArrowDirection;

	ldwImage		  *mArrow;

	int				   mArrowX;
	int				   mArrowY;
	int				   mArrowRange;
	bool               mArrowOnWorld;

	ldwUINT32		   mStartTime;
	ldwUINT32		   mCheckTime;

	double			   mAngle;
	double             mAngleStep;

	int  mResult;
};

#endif
